# BringRPA Chrome 插件配置说明

## 插件配置

### 1. manifest.json 权限配置
插件需要以下权限才能正常运行：

```json
{
  "permissions": [
    "webRequest",      // 网络请求权限
    "scripting",       // 脚本注入权限
    "activeTab",       // 当前标签页权限
    "storage",         // 存储权限
    "tabs",           // 标签页管理权限
    "windows",        // 窗口管理权限
    "webNavigation",  // 网页导航权限
    "alarms"          // 定时任务权限（重要！）
  ]
}
```

### 2. 必需的权限说明
- **alarms**: 用于定时验证API密钥（每5分钟一次）
- **storage**: 用于存储API密钥和设备指纹
- **tabs**: 用于与标签页通信
- **windows**: 用于创建popup窗口

## 安装和运行步骤

### 1. 安装插件
1. 打开Chrome浏览器
2. 进入 `chrome://extensions/`
3. 开启"开发者模式"
4. 点击"加载已解压的扩展程序"
5. 选择 `ext` 文件夹

### 2. 启动后端API服务
```bash
cd api
pip install -r requirements.txt
python dataAPI.py
```
服务将在 `http://127.0.0.1:9966` 启动

### 3. 配置邮箱设置
在 `api/dataAPI.py` 中修改邮箱配置：
```python
SENDER_EMAIL = "your-email@example.com"
SENDER_PASSWORD = "your-password"
SMTP_SERVER = "smtp.gmail.com"
SMTP_PORT = 587
```

## 使用流程

### 1. 首次使用
1. 点击插件图标
2. 选择"免费试用"或输入API密钥
3. 填写邮箱地址（试用）或密钥（已有密钥）
4. 系统自动生成设备指纹并验证
5. 验证成功后跳转到主界面

### 2. 正常使用
- 插件会自动每5分钟验证一次密钥
- 验证失败时会自动停止工作
- 需要重新验证才能继续使用

### 3. 数据采集
1. 在目标网页上点击插件图标
2. 选择要采集的数据区域
3. 配置采集参数
4. 启动自动采集

## 故障排除

### 1. chrome.alarms 未定义错误
**原因**: manifest.json 中缺少 `alarms` 权限
**解决**: 确保 manifest.json 包含 `"alarms"` 权限

### 2. 插件无法启动
**原因**: 后端API服务未启动
**解决**: 启动 `dataAPI.py` 服务

### 3. 密钥验证失败
**原因**: 
- 密钥已过期
- 设备指纹不匹配
- 网络连接问题
**解决**: 
- 检查密钥有效期
- 重新申请密钥
- 检查网络连接

### 4. 数据上传失败
**原因**: API密钥无效或过期
**解决**: 重新验证密钥

## 开发调试

### 1. 查看插件日志
1. 右键点击插件图标
2. 选择"检查弹出内容"
3. 查看Console标签页

### 2. 查看后台日志
1. 进入 `chrome://extensions/`
2. 找到插件
3. 点击"service worker"链接
4. 查看Console标签页

### 3. 调试API接口
使用提供的测试脚本：
```bash
python api/test_device_validation.py
```

## 注意事项

1. **设备绑定**: 每个API密钥只能在一台设备上使用
2. **自动验证**: 插件会定期验证密钥有效性
3. **数据安全**: 所有数据通过HTTPS传输
4. **权限管理**: 插件只请求必要的权限
5. **兼容性**: 支持Chrome 88+版本
